/****************************************************************************
//
// Get an pdb object and caculate Hessian matrix based on the information in the nodes.txt
// file. 
// First element in the Hessian matrix is in index 1 and last in total_number_of_nodes.
//
// Eran, 9/2005
//
****************************************************************************/

float cal_sqr_dist(net *netobj , int i, int j) ;

void generate_hessian (net *netobj , char chain  , float **hessian,  char **nodetypes , int nnodetypes , float  *halfcutoffs , char **nodetypesligands , char **noderesligands , int nnodetypesligands , float  *halfcutoffsligands)  {

int total_number_of_nodes ;
int j,k,jj,kk ;
float distjksqr ;
double ga ;
double bx, by, bz ;
float cutoff ;
float thdistnode[100000] ;


total_number_of_nodes = netobj->numnodes ;

// Initialise the Hessian

for (j=0 ; j<total_number_of_nodes ; j++) {
	for (k=0 ; k < nnodetypes ; k++)  {
		if (!strcmp(netobj->nodes[j].atomname , nodetypes[k])) {
			thdistnode[j] = halfcutoffs[k] ;
			break ;
		}
	}		
}			

// loop to assign cutoffs to ligand nodes

for (j=0 ; j<total_number_of_nodes ; j++) {
	for (k=0 ; k < nnodetypesligands ; k++)  {
		// printf ("*%s*%s*%s*%s*\n" , netobj->nodes[j].atomname , nodetypesligands[k] , netobj->nodes[j].resname , noderesligands[k]) ;
		if ((!strcmp(netobj->nodes[j].atomname , nodetypesligands[k])) && (!strcmp(netobj->nodes[j].resname , noderesligands[k]))) {
			thdistnode[j] = halfcutoffsligands[k] ;
			break ;
		}
	}		
}			


for (j=0 ; j<3*total_number_of_nodes ; j++) 
	for (k=0 ; k<3*total_number_of_nodes ; k++) 
		hessian[j+1][k+1] = 0.0 ;


for (jj=0 ; jj<total_number_of_nodes ; jj++) {
	for (kk=0 ; kk<total_number_of_nodes ; kk++) {
            	ga=1.0 ;
            	bx=netobj->nodes[jj].coor[0] - netobj->nodes[kk].coor[0] ;
           	by=netobj->nodes[jj].coor[1] - netobj->nodes[kk].coor[1] ;
            	bz=netobj->nodes[jj].coor[2] - netobj->nodes[kk].coor[2] ;
 	    	distjksqr = cal_sqr_dist(netobj , jj , kk) ;
 		if (jj==kk) continue ;
		cutoff = thdistnode[jj] + thdistnode[kk] ;
 		if (distjksqr < cutoff*cutoff) {
			j = jj+1 ; // to move from (0..total_number_of_nodes-1) to (1..total_number_of_nodes)
			k = kk+1 ; // to move from (0..total_number_of_nodes-1) to (1..total_number_of_nodes)
			
			// diagonals of diagonal super elements (for j)
              	      	
			hessian[3*j-2][3*j-2]      = hessian[3*j-2][3*j-2]+ga*bx*bx/distjksqr;
               	       	hessian[3*j-1][3*j-1]      = hessian[3*j-1][3*j-1]+ga*by*by/distjksqr;
			hessian[3*j][3*j]          = hessian[3*j][3*j]+ga*bz*bz/distjksqr;
                       
			// off-diagonals of diagonal superelements (for j)
			
			hessian[3*j-2][3*j-1]      = hessian[3*j-2][3*j-1]+ga*bx*by/distjksqr;
			hessian[3*j-2][3*j]        = hessian[3*j-2][3*j]+ga*bx*bz/distjksqr;
			hessian[3*j-1][3*j-2]      = hessian[3*j-1][3*j-2]+ga*by*bx/distjksqr;
			hessian[3*j-1][3*j]        = hessian[3*j-1][3*j]+ga*by*bz/distjksqr;
			hessian[3*j][3*j-2]        = hessian[3*j][3*j-2]+ga*bx*bz/distjksqr;
			hessian[3*j][3*j-1]        = hessian[3*j][3*j-1]+ga*by*bz/distjksqr;
	
			// diagonals of off-diagonal superelements (for j&k)

			hessian[3*j-2][3*k-2]      = -ga*bx*bx/distjksqr;
			hessian[3*j-1][3*k-1]      = -ga*by*by/distjksqr;
			hessian[3*j][3*k]          = -ga*bz*bz/distjksqr;

			// off-diagonals of off-diagonal superelements (for j&k)

			hessian[3*j-2][3*k-1]      = -ga*bx*by/distjksqr;
			hessian[3*j-2][3*k]        = -ga*bx*bz/distjksqr;
			hessian[3*j-1][3*k-2]      = -ga*by*bx/distjksqr;
			hessian[3*j-1][3*k]        = -ga*by*bz/distjksqr;
			hessian[3*j][3*k-2]        = -ga*bx*bz/distjksqr;
			hessian[3*j][3*k-1]        = -ga*by*bz/distjksqr;
		}
		
	}
}

}
	
		
float cal_sqr_dist(net *netobj , int i, int j) {
	return      ( (netobj->nodes[i].coor[0]-netobj->nodes[j].coor[0])*(netobj->nodes[i].coor[0]-netobj->nodes[j].coor[0]) +
	              (netobj->nodes[i].coor[1]-netobj->nodes[j].coor[1])*(netobj->nodes[i].coor[1]-netobj->nodes[j].coor[1]) +
		      (netobj->nodes[i].coor[2]-netobj->nodes[j].coor[2])*(netobj->nodes[i].coor[2]-netobj->nodes[j].coor[2]) ) ;
}
		
