/****************************************************************************
//
// Get an pdb object and caculate Hessian matrix based on Ca
// information. 
// First element in the Hessian matrix is in index 1 and last in total_number_of_residues.
//
// Eran, 9/2005
//
****************************************************************************/

double cal_sqr_dist(net *netobj , int i, int j) ;

void generate_hessian (net *netobj , char chain  , float **hessian,  char **nodetypes , int nnodetypes , float  *halfcutoffs , char **nodetypesligands , char **noderesligands , int nnodetypesligands , float  *halfcutoffsligands)  {

int total_number_of_nodes ;
int j,k,jj,kk ;
double distjksqr , distsqr ;
double ga , binadd ;
double bx, by, bz ;
double dist ;
FILE *fh ;	
char file[50] ;
float thdistnode[100000] ;
float cutoff ;

strcpy(file , netobj->file) ;

total_number_of_nodes = netobj->numnodes ;

// Initialise the Hessian and put thresholds

for (j=0 ; j<total_number_of_nodes ; j++) {
	for (k=0 ; k < nnodetypes ; k++)  {
		if (!strcmp(netobj->nodes[j].atomname , nodetypes[k])) {
			thdistnode[j] = halfcutoffs[k] ;
			break ;
		}
	}		
}			

// loop to assign cutoffs to ligand nodes

for (j=0 ; j<total_number_of_nodes ; j++) {
	for (k=0 ; k < nnodetypesligands ; k++)  {
		// printf ("*%s*%s*%s*%s*\n" , netobj->nodes[j].atomname , nodetypesligands[k] , netobj->nodes[j].resname , noderesligands[k]) ;
		if ((!strcmp(netobj->nodes[j].atomname , nodetypesligands[k])) && (!strcmp(netobj->nodes[j].resname , noderesligands[k]))) {
			thdistnode[j] = halfcutoffsligands[k] ;
			break ;
		}
	}		
}			




fh =  fopen(strcat(file, ".sparsehessian") , "w") ;

for (jj=0 ; jj<total_number_of_nodes ; jj++) {
	for (kk=0 ; kk<total_number_of_nodes ; kk++) {
 		if (jj==kk) continue ;
 	    	distsqr = cal_sqr_dist(netobj , jj , kk) ;
		cutoff = thdistnode[jj] + thdistnode[kk] ;
 		if (distsqr < cutoff*cutoff) {
			j = jj+1 ;
			k = kk+1 ;		
		
            		bx=netobj->nodes[jj].coor[0] - netobj->nodes[kk].coor[0] ;
           		by=netobj->nodes[jj].coor[1] - netobj->nodes[kk].coor[1] ;
            		bz=netobj->nodes[jj].coor[2] - netobj->nodes[kk].coor[2] ;
			// j = jj+1 ; // to move from (0..total_number_of_residues-1) to (1..total_number_of_residues)
			// k = kk+1 ; // to move from (0..total_number_of_residues-1) to (1..total_number_of_residues)
		
			ga = 1 ;
			
			if (k>j)  {
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-2 , 3*k-2 , -ga*bx*bx/distsqr ) ;
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-1 , 3*k-1 , -ga*by*by/distsqr ) ;
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j   , 3*k   , -ga*bz*bz/distsqr ) ;
			
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-2 , 3*k-1 , -ga*bx*by/distsqr ) ;
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-2 , 3*k   , -ga*bx*bz/distsqr ) ;
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-1 , 3*k-2 , -ga*by*bx/distsqr ) ;
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-1 , 3*k   , -ga*by*bz/distsqr ) ;
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j   , 3*k-2 , -ga*bx*bz/distsqr ) ;
				fprintf (fh , "%8d%8d% 25.15e\n" , 3*j   , 3*k-1 , -ga*by*bz/distsqr ) ;
			} 
			
			// diagonals of diagonal super elements (for j)
              	
			hessian[3*j-2][1]      = hessian[3*j-2][1]+ga*bx*bx/distsqr ;
               		hessian[3*j-1][2]      = hessian[3*j-1][2]+ga*by*by/distsqr ;
			hessian[3*j][3]        = hessian[3*j][3]+ga*bz*bz/distsqr ;

			// hessian[3*k-2][1]	  = hessian[3*k-2][1]+ga*bx*bx/distsqr ;
               		// hessian[3*k-1][2]	  = hessian[3*k-1][2]+ga*by*by/distsqr ;
			// hessian[3*k][3]	  = hessian[3*k][3]+ga*bz*bz/distsqr ;
                
			// off-diagonals of diagonal superelements (for j)
		
			hessian[3*j-2][2]      = hessian[3*j-2][2]+ga*bx*by/distsqr ;
			hessian[3*j-2][3]      = hessian[3*j-2][3]+ga*bx*bz/distsqr ;
			hessian[3*j-1][1]      = hessian[3*j-1][1]+ga*by*bx/distsqr ;
			hessian[3*j-1][3]      = hessian[3*j-1][3]+ga*by*bz/distsqr ;
			hessian[3*j][1]        = hessian[3*j][1]+ga*bx*bz/distsqr ;
			hessian[3*j][2]        = hessian[3*j][2]+ga*by*bz/distsqr ;
	
			// hessian[3*k-1][1]	  = hessian[3*k-1][1]+ga*bx*by/distsqr ;
			// hessian[3*k][1]	  = hessian[3*k][1]  +ga*bx*bz/distsqr ;
			// hessian[3*k-2][2]	  = hessian[3*k-2][2]+ga*by*bx/distsqr ;
			// hessian[3*k][2]	  = hessian[3*k][2]  +ga*by*bz/distsqr ;
			// hessian[3*k-2][3]	  = hessian[3*k-2][3]+ga*bx*bz/distsqr ;
			// hessian[3*k-1][3]	  = hessian[3*k-1][3]+ga*by*bz/distsqr ;

			// diagonals of off-diagonal superelements (for j&k)

			// hessian[3*j-2][3*k-2]      = -ga*bx*bx/distsqr;
			// hessian[3*j-1][3*k-1]      = -ga*by*by/distsqr;
			// hessian[3*j][3*k]	      = -ga*bz*bz/distsqr;

			// off-diagonals of off-diagonal superelements (for j&k)

			// hessian[3*j-2][3*k-1]      = -ga*bx*by/distsqr;
			// hessian[3*j-2][3*k]        = -ga*bx*bz/distsqr;
			// hessian[3*j-1][3*k-2]      = -ga*by*bx/distsqr;
			// hessian[3*j-1][3*k]        = -ga*by*bz/distsqr;
			// hessian[3*j][3*k-2]        = -ga*bx*bz/distsqr;
			// hessian[3*j][3*k-1]        = -ga*by*bz/distsqr;
		}
	}
}

for (jj=0 ; jj<total_number_of_nodes ; jj++) {
	j=jj+1 ;
	fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-2 , 3*j-2   , hessian[3*j-2][1] ) ;
	fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-2 , 3*j-1   , hessian[3*j-2][2] ) ;
	fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-2 , 3*j     , hessian[3*j-2][3] ) ;
	fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-1 , 3*j-1   , hessian[3*j-1][2] ) ;
	fprintf (fh , "%8d%8d% 25.15e\n" , 3*j-1 , 3*j     , hessian[3*j-1][3] ) ;
	fprintf (fh , "%8d%8d% 25.15e\n" , 3*j   , 3*j     , hessian[3*j][3]  ) ;
}

fclose (fh) ;

}

	
double cal_sqr_dist(net *netobj , int i, int j) {
	return      ( (netobj->nodes[i].coor[0]-netobj->nodes[j].coor[0])*(netobj->nodes[i].coor[0]-netobj->nodes[j].coor[0]) +
	              (netobj->nodes[i].coor[1]-netobj->nodes[j].coor[1])*(netobj->nodes[i].coor[1]-netobj->nodes[j].coor[1]) +
		      (netobj->nodes[i].coor[2]-netobj->nodes[j].coor[2])*(netobj->nodes[i].coor[2]-netobj->nodes[j].coor[2]) ) ;
}
