#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "pdbnodes.h"
#include "check_modified_aa.c"
#include "read_node_types.c"
#include "generate_hessian_from_pdb.c" 
#include "svd.c"
  
int main (int argc , char *argv[])   {

void print_eigenvalues (net *netobj , float *d) ;
void print_eigenvectors (net *netobj , float *d , float **v) ;
void pseudoinverse(float d[], float **v, float **crc, int n) ;
void print_hessian(net *netobj , float **invhessian) ;
void print_sparse_hessian(net *netobj , float **invhessian) ;
void print_pseudoinverse(net *netobj , float **invhessian) ;
void print_indexing(net *netobj , double mean , double std) ;
void print_log_file(char *file , char chain , int number_of_nodes , float th) ; 
void calculate_bfac_stat(net *netobj , char chain , double *mean , double *std) ;

float **v ;
float *d ;
float **hessian , **invhessian , **cc ,  **modes ;
int nrot ;
int num_of_nodes ;
int n,m ;
net *netobj ;
char **nodetypes , **noderesligands , **nodetypesligands ;
int nnodetypes , nnodetypesligands ;
float halfcutoffs[100] , halfcutoffsligands[100] ;
double mean, std ;
int cutoff ;  // New addition 11/2006. cutoff is determined by nodes.txt
int model ;

// check input parameters. 

if ((argc<=2) || (!strcmp(argv[1], "help")) || (!strcmp(argv[1], "-help")) || (!strcmp(argv[1], "-h")) | (!strcmp(argv[1], "--h")) || (!strcmp(argv[1], "h"))) {
	system ("more readme.txt") ;
	return (1) ;
}

nodetypes = malloc (100*sizeof(char *));
noderesligands   = malloc (100*sizeof(char *));
nodetypesligands = malloc (100*sizeof(char *));
for (n = 0 ; n<100 ; n++) {
	nodetypes[n] = malloc (10*sizeof(char));
	noderesligands[n]      = malloc (10*sizeof(char *));
	nodetypesligands[n]    = malloc (10*sizeof(char *));
}
netobj = malloc (sizeof(net));
model = atoi(argv[3]) ;
readnodetypes ("nodes.txt", nodetypes , &nnodetypes  , halfcutoffs) ;
readligandnodetypes ("ligand_nodes.txt", nodetypesligands ,  noderesligands , &nnodetypesligands  , halfcutoffsligands) ;

// readpdb(argv[1] , netobj , argv[2][0]) ;   // argv[1]: pdb file , argv[2] : chain
readnodes(argv[1] , netobj , argv[2][0] , model , nodetypes , nnodetypes , nodetypesligands ,  noderesligands , nnodetypesligands) ;   // argv[1]: pdb file , argv[2][0] : chain , 
num_of_nodes = netobj->numnodes   ;
// cutoff = atof( argv[3]) ;
// printf ("numres is %d\n" , netobj->numres) ;
num_of_nodes = netobj->numnodes   ;

// memory allocations:

hessian = malloc ((3*num_of_nodes+3)*sizeof(double *)) ;
invhessian = malloc ((3*num_of_nodes+3)*sizeof(double *)) ;
cc = malloc ((3*num_of_nodes+3)*sizeof(double *)) ;
v = malloc ((3*num_of_nodes+3)*sizeof(double *)) ;
d = malloc ((3*num_of_nodes+3)*sizeof(double)) ;
modes = malloc ((3*num_of_nodes+3)*sizeof(double *)) ;

for (n=1 ; n<=3*num_of_nodes ; n++)  {
        hessian[n] = malloc ((3*num_of_nodes+3)*sizeof(double));
        invhessian[n] = malloc ((3*num_of_nodes+3)*sizeof(double));
        cc[n] = malloc ((3*num_of_nodes+3)*sizeof(double));
        v[n]   = malloc ((3*num_of_nodes+3)*sizeof(double));
        modes[n]   = malloc ((3*num_of_nodes+3)*sizeof(double));
	for (m=1 ; m<=3*num_of_nodes ; m++)  {
		hessian[n][m] = 0.0 ;
	}
}
generate_hessian(netobj , argv[2][0] , hessian , nodetypes , nnodetypes  , halfcutoffs , nodetypesligands , noderesligands  , nnodetypesligands  , halfcutoffsligands) ;
print_hessian(netobj , hessian) ;
print_sparse_hessian(netobj , hessian) ;

svdcmp(hessian, 3*num_of_nodes , 3*num_of_nodes , d , v) ;

v = hessian ; // the svdcmp function  assigns the orthogonal basis to the input pointer (hessian)

eigsrt(d, v, 3*num_of_nodes) ;
pseudoinverse(d, v, invhessian , num_of_nodes) ;
calculate_bfac_stat(netobj , argv[2][0] , &mean , &std) ;

print_indexing(netobj , mean , std) ;
print_log_file(argv[1] , argv[2][0] , num_of_nodes , cutoff) ;
print_eigenvalues(netobj , d) ; 
print_eigenvectors(netobj , d , v) ; 
print_pseudoinverse(netobj , invhessian) ;

}


void print_eigenvalues (net *netobj , float *d)  {
	int n ;
	int num_of_nodes ;
	FILE *fh ;	

	char file[50] ;
	
	num_of_nodes = netobj->numnodes ;
	
	strcpy(file , netobj->file) ;
	fh =  fopen(strcat(file, ".eigenvalues") , "w") ;
	for (n=1 ;  n<=3*num_of_nodes ; n++)  {
		fprintf (fh , "%10.5f\n" , d[n]) ;
	}
	fclose (fh) ;
}

void print_eigenvectors (net *netobj , float *d , float **v)  {
	int m,n ;
	int num_of_nodes ;
	FILE *fh , *fx , *fy , *fz ;
	char file[50] ;
	int filenamelength ;
	
	num_of_nodes = netobj->numnodes ;
	
	strcpy(file , netobj->file) ;
	filenamelength = strlen(file) ;
	
	fh =  fopen(strcat(file, ".eigen") , "w") ;
	for (n=1 ;  n<=3*num_of_nodes ; n++)  {
		for (m=1 ;  m<=3*num_of_nodes ; m++)  {
			fprintf (fh , "%10.5f " , v[n][m]) ;
		}
		fprintf (fh , "\n") ;
	}
	fclose (fh) ;
	
	file[filenamelength] = '\0' ;
	fx =  fopen(strcat(file, ".eigenx") , "w") ;
	file[filenamelength] = '\0' ;
	fy =  fopen(strcat(file, ".eigeny") , "w") ;
	file[filenamelength] = '\0' ;
	fz =  fopen(strcat(file, ".eigenz") , "w") ;
	for (n=1 ;  n<=num_of_nodes ; n++)  {
		for (m=7 ;  m<=3*num_of_nodes ; m++)  {
			fprintf (fx , "%10.5f " , v[n*3-2][m]) ;
			fprintf (fy , "%10.5f " , v[n*3-1][m]) ;
			fprintf (fz , "%10.5f " , v[n*3][m]) ;
		}
		fprintf (fx , "\n") ;
		fprintf (fy , "\n") ;
		fprintf (fz , "\n") ;
	}
	fclose (fx) ;
	fclose (fy) ;
	fclose (fz) ;
	
	
}

void print_hessian(net *netobj , float **hessian)  {
int m,n ;
int num_of_nodes ;
FILE *fh ;	
char file[50] ;

strcpy(file , netobj->file) ;
	
num_of_nodes = netobj->numnodes ;

fh =  fopen(strcat(file, ".hessian") , "w") ;

for (n=1 ;  n<=3*num_of_nodes ; n++)  {
	for (m=1 ;  m<=3*num_of_nodes ; m++)  {
		fprintf (fh , "%11.5f" , hessian[n][m]) ;
	
	}
	fprintf (fh ,"\n") ;
}

fclose (fh) ;

}

void print_sparse_hessian(net *netobj , float **hessian)  {
int m,n ;
int num_of_nodes ;
FILE *fh ;	
char file[50] ;

strcpy(file , netobj->file) ;
	
num_of_nodes = netobj->numnodes ;

fh =  fopen(strcat(file, ".sparsehessian") , "w") ;

for (n=1 ;  n<=3*num_of_nodes ; n++)  {
	for (m=n ;  m<=3*num_of_nodes ; m++)  {
		if (hessian[n][m] != 0.0)  {
			fprintf (fh , "%8d%8d% 25.15e\n" , n , m , hessian[n][m]) ;
		}
	
	}
}

fclose (fh) ;

}


void print_pseudoinverse(net *netobj , float **invhessian)  {
int m,n ;
int num_of_nodes ;
FILE *fh ;	
char file[50] ;

strcpy(file , netobj->file) ;
	
num_of_nodes = netobj->numnodes ;

fh =  fopen(strcat(file, ".invhessian") , "w") ;

for (n=1 ;  n<=3*num_of_nodes ; n++)  {
	for (m=1 ;  m<=3*num_of_nodes ; m++)  {
		fprintf (fh , "%10.5f " , invhessian[n][m]) ;
	
	}
	fprintf (fh ,"\n") ;
}

fclose (fh) ;

}

void print_indexing(net *netobj , double mean , double std)  {
int i ;
int num_of_nodes ;
FILE *fh ;	
char file[50] ;

strcpy(file , netobj->file) ;
	
num_of_nodes = netobj->numnodes ;

fh =  fopen(strcat(file, ".index") , "w") ;

for (i=0 ;  i<num_of_nodes ; i++)  {
	fprintf (fh , "%5d %3s %4s %5d%c %c %3d %8.3f %8.3f %8.3f %9.3f %9.3f\n" , i+1 , netobj->nodes[i].resname , netobj->nodes[i].atomname , netobj->nodes[i].pdbcoornum , 
	                  netobj->nodes[i].insertioncode , netobj->nodes[i].chain , netobj->nodes[i].model , 
			  netobj->nodes[i].coor[0] , netobj->nodes[i].coor[1] , netobj->nodes[i].coor[2] ,
			  netobj->nodes[i].bfac, (netobj->nodes[i].bfac-mean)/std ) ; 
}

fclose (fh) ;

}


void print_log_file(char *file , char chain , int number_of_nodes , float th) {

time_t t ;
FILE *fh ;	
char tmpfile[50] ;
char *ts ;

strcpy(tmpfile , file) ;

fh =  fopen(strcat(file, ".log") , "w") ;
t = time(NULL) ;
ts = ctime(&t) ;

fprintf (fh , "%s" , ts) ;
fprintf (fh , "file: %s chain: %c\n" , tmpfile , chain ) ;
fprintf (fh , "residues: %d\n" , number_of_nodes ) ;
fprintf (fh , "th: %f\n" , th) ;

fclose (fh) ;

}

void pseudoinverse(float d[], float **v, float **crc, int n)  {

/**********************************************************************************************
// 
// Given the eigenvalues d[7..3*n] and eigenvectors v[7..n][1..n] 
// calculate the psedo inverse of the original symmetrical matrix.
// This inverse - crc corresponds to the correlation and the crosscorrelations as:
// <DrTi*Drj> = 3kbT/Gamma * crc(i,j)
//
// Eran (9/2005) 
//
**********************************************************************************************/


int k,j,i;

for (i=1;i<=3*n;i++)   {		 // index for row
	for (j=1;j<=3*n;j++)    {        // index for column
		crc[i][j] = 0.0 ;
		for (k=7;k<=3*n;k++)  {  // index for Eigenvalue and corresponding eigen vector igmoring the first
			crc[i][j] += (v[i][k]*v[j][k]/d[k]) ;
			// crc[j][i] = crc[i][j] ;
		}
	}
}

}


void calculate_bfac_stat(net *netobj , char chain , double *mean , double *std) {

/*************************************************************************************************
//
// Calculate Mean and STD to the B-factor values of the CA atoms
//
//
// Eran (10/2005)
//
*************************************************************************************************/

int i ;
int num_of_nodes_counted=0 ;
int num_of_nodes ;
double sum_sqdev=0.0 ;

*mean=0.0 ;

num_of_nodes = netobj->numnodes ;

for (i=0 ; i<num_of_nodes ; i++)  {
	if (((chain == netobj->nodes[i].chain) || (chain == '*')) && (netobj->nodes[i]. bfac != -9999))  {
		*mean += netobj->nodes[i].bfac;
		num_of_nodes_counted++ ;
	}
}

*mean /= num_of_nodes_counted ;

for (i=0 ; i<num_of_nodes ; i++)  {
	if (((chain == netobj->nodes[i].chain) || (chain == '*')) && (netobj->nodes[i]. bfac != -9999))  {
		sum_sqdev += (netobj->nodes[i].bfac-(*mean))*(netobj->nodes[i].bfac-(*mean)) ;
	}
}

*std = sqrt(sum_sqdev/num_of_nodes_counted) ;

}


/*

sparse matrix format:
01234567890123456789012345678901234567890
          1         2         3         4

       1       1    0.163988852795849E+02
       1       2    0.284541052833137E+01
       1       3   -0.224532282166162E+01
*/

